#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/07/09 16:11:32
#   Desc    :   分期合作第三方错误码转换
#

from gm_types.error import ERROR

from rpc.exceptions import GaiaRPCFaultException
from rpc.tool.log_tool import installment_logger as log


XY_CODE = {
    'calculate': {
        -100: '参数输入有误',
        -900: '调用server返回失败',
    },
    'registerAndVerify': {
        -2000: '输入有误, 请核实',
        -3000: '手机号验证失败，请输入其他手机号',
        -4000: '实名认证失败，请校验姓名和身份证号信息',
        -5000: '手机号验证失败，请输入其他手机号',
        -6000: '身份证号已和其他手机号关联，请重新输入~',
        -7000: '注册失败请重试',
        -8000: '实名认证失败，请校验姓名和身份证号信息',
    },
    'checkSecureBank': {
        -1000: '输入无效，请重新输入',
        -3000: '绑定卡已存在，请重新输入其他银行卡',
        -4000: '绑定失败，请重试',
    },
    'bindSecureBank': {
        -1000: '输入无效，请重新输入',
        -3000: '验证码错误',
        -4000: '系统错误，请重试',
        -5000: '系统错误，请重试',
    },
    'createLoan': {
        -1000: '输入无效，请重新输入',
        -2000: '无用户信息',
        -3000: '借款失败，请重试',
    },
    'loanReplenish': {
        -1000: '输入无效，请重新输入',
        -2000: '无申请信息，请申请',
    },
    'confirmLoan': {
        -1000: '输入无效，请重新输入',
        -2000: '无申请信息，请申请',
        -3000: '无用户信息，请补充',
        -4000: '未绑定银行卡',
        -5000: '系统错误，请重试',
    },
    'loanDetail': {
        -1000: '无效的输入',
        -2000: '无借款信息',
    },
    'loanAuditDetail': {
    },

}


class XiaoYingError(Exception):

    def __init__(self, request_id, code, message):
        self.request_id = request_id
        self.code = code
        self.message = message


class InstallmentError(GaiaRPCFaultException):

    def __init__(self, endpoint, response, request_id):
        self.error = ERROR.XIAOYING_ERROR
        self.data = response['ret']
        if self.data in (-50, -100):   # 小赢确认过的仅有的两个全局错误
            raise XiaoYingError(request_id, self.data, response['msg'])
        self.message = XY_CODE[endpoint].get(response['ret'])
        if self.message is None:
            log.info({
                'info': 'receive code error',
                'code': self.data,
                'msg': response['msg'],
                'request_id': request_id})
            self.message = response['msg']
        self.request_id = request_id
        pass


class GmeiError(GaiaRPCFaultException):
    def __init__(self, code, data=None):
        self.error = code
        self.data = data
        self.message = ERROR.getDesc(code)
