# coding=utf-8
from django.core.mail import EmailMessage, get_connection
from django.conf import settings

connection = get_connection(
        username=settings.PAY_EMAIL_USER,
        password=settings.PAY_EMAIL_USER_PWD,
)


def send_email(from_email, to_email_list, subject, body):
    mail = EmailMessage(connection=connection)
    mail.from_email = from_email
    if settings.DEBUG:
        subject = '[TEST]' + subject
    mail.subject = subject
    mail.to = to_email_list
    mail.body = body
    return mail.send()


