# coding=utf-8
# create by oldman at 2017/10/31
from gm_types.trade import STATEMENT_OPERATION_TYPE, STATEMENT_STATUS

from pay.models.statementall import StatementAll
from pay.models.statementalloperation import CreateOp, ApplyOp, AuditOp, CheckOp, RefuseOp, SettleOp, NameDefaultOp, \
    BankDefaultOp, FinResetOp
from pay.tool import DatetimeTool
from rpc.decorators import bind_context
from rpc.tool.error_code import gen
from rpc.tool.error_code import CODES
from api.tool.user_tool import get_user_from_context


def _operate(operator, statementall_id, operation_type):
    try:
        statementall = StatementAll.objects.get(pk=statementall_id)
    except StatementAll.DoesNotExist:
        raise gen(CODES.STATEMENT_NOT_EXIST)
    op_list = (
        CreateOp, ApplyOp, AuditOp, CheckOp, RefuseOp, SettleOp, NameDefaultOp,
        BankDefaultOp, FinResetOp,
    )
    opFactory = None
    for modelOp in op_list:
        if modelOp.optype == operation_type:
            opFactory = modelOp
            break
    op = opFactory(statementall=statementall, operator=operator)
    op.do()


@bind_context('trade/statement_all/audit')
def trade_statement_all_audit(ctx, statement_all_id):
    """
    运营审核通过对账单
    :param ctx:
    :param statement_id:
    :return:
    """
    user = get_user_from_context(ctx)
    _operate(
        operator=user.person,
        statementall_id=statement_all_id,
        operation_type=STATEMENT_OPERATION_TYPE.AUDIT
    )


@bind_context('trade/statement_all/one_key_audit')
def statement_all_one_key_audit(ctx):
    """
    一鍵通过对账单
    :param ctx:
    :return:
    """
    user = get_user_from_context(ctx)
    dt = DatetimeTool()
    last_month = dt.get_first_day_month(d_months=-1).strftime("%Y%m")
    statements = StatementAll.objects.filter(statement_date=last_month, status=STATEMENT_STATUS.APPLIED)
    for statement in statements:
        AuditOp(statement, operator=user.person).do()
    return [statement.id for statement in statements]


@bind_context('trade/statement_all/fin_reset', login_required=True)
def trade_statement_all_fin_reset(ctx, statement_all_id):
    """
    重置结算单状态
    :param ctx:
    :param statement_id:
    :return:
    """
    user = get_user_from_context(ctx)
    _operate(
        operator=user.person,
        statementall_id=statement_all_id,
        operation_type=STATEMENT_OPERATION_TYPE.FIN_RESET
    )


@bind_context('trade/statement_all/settle', login_required=True)
def trade_statement_all_settle(ctx, statement_all_id):
    """
    标记为已结算
    :param ctx:
    :param statement_id:
    :return:
    """
    user = get_user_from_context(ctx)
    _operate(
        operator=user.person,
        statementall_id=statement_all_id,
        operation_type=STATEMENT_OPERATION_TYPE.SETTLE
    )


@bind_context('trade/statement_all/bank_defeat', login_required=True)
def trade_statement_all_bank_defeat(ctx, statement_all_id):
    """
    财务打款失败:帐号错误
    :param ctx:
    :param statement_all_id:
    :return:
    """
    user = get_user_from_context(ctx)
    _operate(
        operator=user.person,
        statementall_id=statement_all_id,
        operation_type=STATEMENT_OPERATION_TYPE.BANK_DEFEAT
    )


@bind_context('trade/statement_all/name_defeat', login_required=True)
def trade_statement_all_name_defeat(ctx, statement_all_id):
    """
    财务打款失败:用户名错误
    :param ctx:
    :param statement_all_id:
    :return:
    """
    user = get_user_from_context(ctx)
    _operate(
        operator=user.person,
        statementall_id=statement_all_id,
        operation_type=STATEMENT_OPERATION_TYPE.NAME_DEFEAT
    )