#!/usr/bin/env python
# -*- coding: utf-8 -*-
import os

from django.conf import settings
from django.core.management import BaseCommand
from gm_types.gaia import TAG_TYPE

from api.models import Tag
from utils.execel import ExcelWriter


excel = ExcelWriter("没有聚合页的运营标签.xlsx")
excel.write_header(['标签ID', '标签名称'])


class Command(BaseCommand):
    """
    统计没有聚合页的运营标签
    """

    def handle(self, *args, **kwargs):
        tags = Tag.objects.using(settings.SLAVE_DB_NAME).filter(is_online=True, tag_type=TAG_TYPE.YUNYING)
        row_num = 2
        for tag in tags.iterator():
            polymer = tag.polymer.first()
            if not polymer:
                excel.write_row(row_num=row_num, values=[tag.id, tag.name])
                row_num += 1
        excel.save()

        print(u'总数:', row_num-2)
        print('DONE')
