# coding=utf-8

"""
NOTE: if update error code here, please let whole backend team know about it.
"""

from __future__ import unicode_literals, absolute_import, print_function

from gm_types.error import ERROR as CODES

__author__ = 'leaf'


def gen(code, **kwargs):
    from rpc.exceptions import GaiaRPCFaultException

    if code != 0:
        raise GaiaRPCFaultException(
            error=code,
            message=CODES.getDesc(code),
            data=None,
        )

    return {
        "error": 0,
        "message": '',
        "data": kwargs,
    }
