# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


def service_suggested_diaries(service_id, doctor_id, offset, size):
    from api.models import DIARY_ORDER_TYPE
    from .utils.diary import filter_diary
    result = filter_diary(
        offset=offset,
        size=size,
        sort_type=DIARY_ORDER_TYPE.SERVICE_RELATED,
        filters={
            'doctor_id': doctor_id,
        },
        nfilters={
            'user_ids': [22],
        },
        sort_params={
            'service_id': service_id,
        },
    )
    return result['diary_ids']


