# coding=utf-8
import tablib
from celery import shared_task
from django.core.mail import EmailMessage, get_connection

from api.models import *
from search.utils.diary import caculate_diarys_with_penlaty
from search.utils.diary import get_es_diary_data

connection = get_connection(
    username=settings.HERA_EMAIL_USER,
    password=settings.HERA_EMAIL_PSWD,
)


def get_mail(sub, body, to_user_email, dt):
    mail = EmailMessage(connection=connection)
    mail.from_email = settings.HERA_EMAIL_USER
    mail.subject = sub
    mail.to = to_user_email
    mail.body = body
    mail.attach(u'{}.xlsx'.format(sub), dt.xlsx)
    return mail


@shared_task
def export_email(to_user_email):
    dt = tablib.Dataset()
    dt.headers = [
        u'日记本ID', u'排序得分', u'标题', u'用户名', u'内容质量', u'医生', u'医院', u'医生所在城市',
        u'创建时间', u'更新时间', u'日记帖', u'点赞数', u'回复数', u'收入贡献分', u'项目标签', u'加权操作',
        u'医生医院重复扣分', u'没有美购扣分', u'最终得分',
    ]
    hits = get_es_diary_data(sort_params=None)
    diarys_with_penlaty = caculate_diarys_with_penlaty(hits)
    for hit in hits:
        source = hit['_source']
        diary_id = hit['_id']
        try:
            diary = Diary.objects.get(id=diary_id)
        except Diary.DoesNotExist:
            pass

        for diary_with_penlaty in diarys_with_penlaty:
            if str(diary_with_penlaty['id']) == str(diary_id):
                original_score = diary_with_penlaty['original_score']
                duplication_penalty_score = diary_with_penlaty['duplication_penalty_score']
                missing_service_penalty_score = diary_with_penlaty['missing_service_penalty_score']
                final_score = diary_with_penlaty['final_score']

                try:
                    doctor_city = diary.doctor.hospital.city.name
                except:
                    doctor_city = u''
                heat_score, audit_score, choucheng_score = diary.get_index_rank()
                additional_score = diary.diary_rank.additional_score if getattr(diary, 'diary_rank', False) else 0

                x = (
                    diary.id,
                    original_score,
                    diary.title,
                    diary.user.last_name,
                    DIARY_CONTENT_LEVEL.getDesc(diary.content_level),
                    getattr(diary.doctor, 'name', ''),
                    getattr(diary.hospital, 'name', ''),
                    doctor_city,
                    diary.created_time,
                    diary.last_modified,
                    diary.topic_num,
                    diary.like_num,
                    diary.reply_num,
                    choucheng_score,
                    u'、'.join(diary.tags.values_list('name', flat=True)),
                    additional_score,
                    duplication_penalty_score,
                    missing_service_penalty_score,
                    final_score,
                )
                dt.append(x)
    body = u'首页日记本排序top1000'
    get_mail(u'首页日记本排序top1000', body, to_user_email, dt).send()
