# coding=utf-8
from __future__ import unicode_literals, absolute_import

from rpc.decorators import bind_context
from social.models import UserFollow


@bind_context('social/user/follow')
def user_relation(ctx, user_id, follow_id):
    try:
        relation = UserFollow.objects.get(user_id=user_id, follow_id=follow_id)
        if relation.bond:
            return {"followed":True}
        else:
            return {"followed":False}
    except UserFollow.DoesNotExist:
        return {"followed":False}


@bind_context('social/suozhang/push_topic_in_mailbox')
def push_topic_in_mailbox(ctx, id):
    return
