-- depension: None
-- model api.models.reservation api.models.doctor
-- description: 添加表api_schedule(Schedule) api_scheduletimeslot(ScheduleTimeslot) api_doctoraddress(DoctorAddress) api_reservation(Reservation) 添加accept_reserve(接受邀请)到表api_doctor(Doctor)
-- author: Jiabin.Wang
-- date: 2015-09-13 22:38

begin;

create table `api_doctoraddress` (
`id` int(11) auto_increment not null primary key,
`desc` char(20) not null,
`lng` float not null,
`lat` float not null,
`doctor_id` varchar(100) not null,
`location` char(200) not null
);

alter table api_doctoraddress add constraint `fk_api_doctoraddress_doctor` foreign key (`doctor_id`) references api_doctor (`id`);

create table `api_schedule` (
`id` int(11) auto_increment not null primary key,
`date` datetime not null,
`am_or_pm` char(1) not null,
`start_time` time not null,
`end_time` time not null,
`doctor_id` varchar(11) not null,
`address_id` int(11) not null,
`reservation_type` char(2) not null
)
;

alter table api_schedule add constraint `fk_api_doctor` foreign key (`doctor_id`) references api_doctor (`id`);
alter table api_schedule add constraint `fk_api_doctoraddress` foreign key (`address_id`) references api_doctoraddress (`id`);

create table `api_reservation` (
`id` int(11) auto_increment not null primary key,
`date` datetime not null,
`schedule_id` int(11) not null,
`cancel_operator_role_id` int(100),
`order_id` varchar(100) not null,
`status` char(10) not null,
`user_id` int(11) not null,
`created_time` datetime not null,
`cancel_time` datetime,
`reservation_address` varchar(200) not null,
`reservation_type` char(10) not null
);

alter table api_reservation add constraint `fk_api_reservation_schedule` foreign key (`schedule_id`) references api_schedule (`id`);
alter table api_reservation add constraint `fk_api_reservation_cancel_operator` foreign key (`cancel_operator_role_id`) references auth_user (`id`);
alter table api_reservation add constraint `fk_api_reservation_order` foreign key (`order_id`) references api_order (`id`);
alter table api_reservation add constraint `fk_api_reservation_user` foreign key (`user_id`) references auth_user(`id`);

create table `api_scheduletimeslot` (
`id` int(11) auto_increment not null primary key,
`reservation_id` int(11),
`start_time` datetime not null,
`doctor_id` varchar(100) not null,
`date` datetime not null
);

alter table api_scheduletimeslot add constraint `api_scheduletimeslot_reservation` foreign key (`reservation_id`) references api_reservation (`id`);
alter table api_scheduletimeslot add constraint `api_scheduletimeslot_doctor` foreign key (`doctor_id`) references api_doctor (`id`);

ALTER TABLE api_doctor ADD COLUMN `accept_reserve` boolean DEFAULT False;

commit;
