-- Deploy gaia:2017-04-10_add_shequ_device_and_integralwall to mysql

BEGIN;

CREATE TABLE `api_shequ_integralwall` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `appid` varchar(64) NOT NULL,
    `mac` varchar(64) NOT NULL,
    `idfa` varchar(64) NOT NULL,
    `accept_time` datetime(6) NOT NULL,
    `active_time` datetime(6),
    `callback` varchar(128),
    UNIQUE (`mac`, `idfa`)
)
;
CREATE INDEX `api_shequ_integralwall_802e0977` ON `api_shequ_integralwall` (`idfa`);

CREATE TABLE `statistic_shequdevice_user` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `shequdevice_id` integer NOT NULL,
    `user_id` integer NOT NULL,
    UNIQUE (`shequdevice_id`, `user_id`)
)
;
ALTER TABLE `statistic_shequdevice_user` ADD CONSTRAINT `user_id_refs_id_ff7329fc` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);

CREATE TABLE `statistic_shequdevice` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `device_id` varchar(100) NOT NULL,
    `platform` varchar(20) NOT NULL,
    `version` varchar(10),
    `os_version` varchar(20),
    `model` varchar(40),
    `screen` varchar(40),
    `channel` varchar(40),
    `created_time` datetime(6) NOT NULL,
    `last_activity` datetime(6) NOT NULL,
    `idfv` varchar(100) NOT NULL,
    UNIQUE (`device_id`, `platform`, `idfv`)
)
;
ALTER TABLE `statistic_shequdevice_user` ADD CONSTRAINT `shequdevice_id_refs_id_5822ce40` FOREIGN KEY (`shequdevice_id`) REFERENCES `statistic_shequdevice` (`id`);

CREATE INDEX `statistic_shequdevice_user_8fc540e5` ON `statistic_shequdevice_user` (`shequdevice_id`);
CREATE INDEX `statistic_shequdevice_user_6340c63c` ON `statistic_shequdevice_user` (`user_id`);

COMMIT;
