-- Deploy gaia:2017_11_08_add_lasker to mysql

BEGIN;
CREATE TABLE `lasker_award` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `name` varchar(64) NOT NULL, `image` varchar(128) NOT NULL, `image_styled` varchar(128) NOT NULL, `create_at` datetime(6) NOT NULL, `update_at` datetime(6) NOT NULL);
CREATE TABLE `lasker_lasker` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `year` smallint UNSIGNED NOT NULL UNIQUE, `name` varchar(64) NOT NULL, `create_at` datetime(6) NOT NULL, `update_at` datetime(6) NOT NULL);
CREATE TABLE `lasker_participant` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `doctor_id` varchar(64) NOT NULL, `create_at` datetime(6) NOT NULL, `award_id` integer NOT NULL);
CREATE TABLE `lasker_vote` (`id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY, `wx_uid` varchar(64) NOT NULL, `forged` bool NOT NULL, `create_at` datetime(6) NOT NULL, `participant_id` integer NOT NULL);
ALTER TABLE `lasker_award` ADD COLUMN `lasker_id` integer NOT NULL;
ALTER TABLE `lasker_award` ALTER COLUMN `lasker_id` DROP DEFAULT;
ALTER TABLE `lasker_participant` ADD CONSTRAINT `lasker_participant_doctor_id_16bd6f113bf315c1_uniq` UNIQUE (`doctor_id`, `award_id`);
ALTER TABLE `lasker_award` ADD CONSTRAINT `lasker_award_lasker_id_42191ba415746a54_uniq` UNIQUE (`lasker_id`, `name`);
ALTER TABLE `lasker_participant` ADD CONSTRAINT `lasker_participant_award_id_69b7a76fc4d9fb3a_fk_lasker_award_id` FOREIGN KEY (`award_id`) REFERENCES `lasker_award` (`id`);
ALTER TABLE `lasker_vote` ADD CONSTRAINT `lasker__participant_id_77e6c59e5c37ed20_fk_lasker_participant_id` FOREIGN KEY (`participant_id`) REFERENCES `lasker_participant` (`id`);
CREATE INDEX `lasker_award_bc4a8ddd` ON `lasker_award` (`lasker_id`);
ALTER TABLE `lasker_award` ADD CONSTRAINT `lasker_award_lasker_id_4dac2cd5e4213e1a_fk_lasker_lasker_id` FOREIGN KEY (`lasker_id`) REFERENCES `lasker_lasker` (`id`);

COMMIT;



