-- Deploy gaia:2018_08_16-add-varietyvote-tables to mysql

BEGIN;

CREATE TABLE `api_variety_activity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(100) NOT NULL,
    `title` varchar(100) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `header_banner` varchar(255) NOT NULL,
    `waist_banner` varchar(255) NOT NULL,
    `waist_url` varchar(200) NOT NULL,
    `rule` longtext NOT NULL,
    `is_online` bool NOT NULL
)
;
CREATE TABLE `api_variety_idol` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `activity_id` integer NOT NULL,
    `user_id` integer NOT NULL,
    `nick_name` varchar(50) NOT NULL,
    `icon_url` varchar(255) NOT NULL,
    `hera_vote_num` integer NOT NULL,
    `real_vote` integer NOT NULL,
    `last_modify_time` datetime(6) NOT NULL,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `api_variety_idol` ADD CONSTRAINT `activity_id_refs_id_ab9471b1` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_idol` ADD CONSTRAINT `user_id_refs_id_4b7e0aab` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_idol_invite` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `inviter_id` integer NOT NULL,
    `invitee_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `mobile` varchar(20) NOT NULL,
    `device_model` varchar(40),
    `device_id` varchar(100),
    `device_platform` varchar(20) NOT NULL,
    `device_mul_user` bool NOT NULL,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `api_variety_idol_invite` ADD CONSTRAINT `activity_id_refs_id_be626ccd` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_idol_invite` ADD CONSTRAINT `inviter_id_refs_id_53751faf` FOREIGN KEY (`inviter_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_variety_idol_invite` ADD CONSTRAINT `invitee_id_refs_id_53751faf` FOREIGN KEY (`invitee_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_idol_vote_statistics` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `inviter_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `create_time` date NOT NULL,
    `hera_invite_cnt` integer NOT NULL,
    `real_invite_cnt` integer NOT NULL
)
;
ALTER TABLE `api_variety_idol_vote_statistics` ADD CONSTRAINT `activity_id_refs_id_9e6e2477` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_idol_vote_statistics` ADD CONSTRAINT `inviter_id_refs_id_60aa4aed` FOREIGN KEY (`inviter_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_invite_code` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL UNIQUE,
    `code` varchar(10) NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_variety_invite_code` ADD CONSTRAINT `user_id_refs_id_a8f64ffe` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_user_votenum` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `create_time` date NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `login_vote` integer NOT NULL,
    `invite_vote` integer NOT NULL
)
;
ALTER TABLE `api_variety_user_votenum` ADD CONSTRAINT `activity_id_refs_id_e7f61a0b` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_user_votenum` ADD CONSTRAINT `user_id_refs_id_1a88b293` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_votenum_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `change_type` integer NOT NULL,
    `vote_num` integer NOT NULL,
    `create_time` date NOT NULL
)
;
ALTER TABLE `api_variety_votenum_record` ADD CONSTRAINT `activity_id_refs_id_956e15f3` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_votenum_record` ADD CONSTRAINT `user_id_refs_id_34f328e9` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_vote_Log` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `voter_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `idol_id` integer NOT NULL,
    `is_real` integer NOT NULL,
    `vote_num` integer NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_variety_vote_Log` ADD CONSTRAINT `activity_id_refs_id_7e0fcd8c` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_vote_Log` ADD CONSTRAINT `idol_id_refs_id_fa3c3f69` FOREIGN KEY (`idol_id`) REFERENCES `api_variety_idol` (`id`);
ALTER TABLE `api_variety_vote_Log` ADD CONSTRAINT `voter_id_refs_id_24c491f3` FOREIGN KEY (`voter_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_variety_total_invite` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `inviter_id` integer NOT NULL,
    `activity_id` integer NOT NULL,
    `hera_total_invite` integer NOT NULL,
    `real_total_invite` integer NOT NULL,
    `total_invite_num` integer NOT NULL,
    UNIQUE (`inviter_id`, `activity_id`)
)
;
ALTER TABLE `api_variety_total_invite` ADD CONSTRAINT `activity_id_refs_id_0128ef3b` FOREIGN KEY (`activity_id`) REFERENCES `api_variety_activity` (`id`);
ALTER TABLE `api_variety_total_invite` ADD CONSTRAINT `inviter_id_refs_id_4e6d0858` FOREIGN KEY (`inviter_id`) REFERENCES `auth_user` (`id`);

CREATE INDEX `api_variety_idol_8005e431` ON `api_variety_idol` (`activity_id`);
CREATE INDEX `api_variety_idol_6340c63c` ON `api_variety_idol` (`user_id`);
CREATE INDEX `api_variety_idol_invite_72007adb` ON `api_variety_idol_invite` (`inviter_id`);
CREATE INDEX `api_variety_idol_invite_ea7337f9` ON `api_variety_idol_invite` (`invitee_id`);
CREATE INDEX `api_variety_idol_invite_8005e431` ON `api_variety_idol_invite` (`activity_id`);
CREATE INDEX `api_variety_idol_vote_statistics_72007adb` ON `api_variety_idol_vote_statistics` (`inviter_id`);
CREATE INDEX `api_variety_idol_vote_statistics_8005e431` ON `api_variety_idol_vote_statistics` (`activity_id`);
CREATE INDEX `api_variety_user_votenum_6340c63c` ON `api_variety_user_votenum` (`user_id`);
CREATE INDEX `api_variety_user_votenum_8005e431` ON `api_variety_user_votenum` (`activity_id`);
CREATE INDEX `api_variety_votenum_record_6340c63c` ON `api_variety_votenum_record` (`user_id`);
CREATE INDEX `api_variety_vote_Log_6a184d15` ON `api_variety_vote_Log` (`voter_id`);
CREATE INDEX `api_variety_vote_Log_8005e431` ON `api_variety_vote_Log` (`activity_id`);
CREATE INDEX `api_variety_vote_Log_1ff40e4a` ON `api_variety_vote_Log` (`idol_id`);
CREATE INDEX `api_variety_total_invite_72007adb` ON `api_variety_total_invite` (`inviter_id`);
CREATE INDEX `api_variety_total_invite_8005e431` ON `api_variety_total_invite` (`activity_id`);

COMMIT;
