-- Deploy gaia:2019-07-31-polymer to mysql

BEGIN;

ALTER TABLE `polymer_polymer` ADD COLUMN `pub_type` integer DEFAULT 0 NOT NULL;

ALTER TABLE `api_slide` ADD COLUMN `content_polymer_id` INTEGER;

CREATE TABLE `api_polymer_agiletag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `agile_tag_id` integer NOT NULL,
    `polymer_id` integer NOT NULL
);
CREATE TABLE `api_polymer_tag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    `tag_id` integer NOT NULL,
    `polymer_id` integer NOT NULL
);

CREATE INDEX `api_polymer_agiletag_46e92b39` ON `api_polymer_agiletag` (`agile_tag_id`);
CREATE INDEX `api_polymer_agiletag_d6993334` ON `api_polymer_agiletag` (`polymer_id`);
CREATE INDEX `api_polymer_tag_76f094bc` ON `api_polymer_tag` (`tag_id`);
CREATE INDEX `api_polymer_tag_d6993334` ON `api_polymer_tag` (`polymer_id`);

ALTER TABLE `api_polymer_agiletag` ADD CONSTRAINT `api_polymer_agiletag_agile_tag_id_7f3a2a53b7f817d1_uniq` UNIQUE (`agile_tag_id`, `polymer_id`);
ALTER TABLE `api_polymer_tag` ADD CONSTRAINT `api_polymer_tag_tag_id_7749f4d4115dab4b_uniq` UNIQUE (`tag_id`, `polymer_id`);

COMMIT;
