-- Deploy gaia:2019_01_02_create_table_new_wiki_relation_wordrel to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `wiki_brand_keywords` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `brand_id` integer NOT NULL,
    `wordrel_id` integer NOT NULL,
    `category` varchar(5) NOT NULL,
    `is_effect` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `wiki_brand_keywords` ADD CONSTRAINT `wordrel_id_refs_id_9edb51d3` FOREIGN KEY (`wordrel_id`) REFERENCES `api_wordrel` (`id`);
ALTER TABLE `wiki_brand_keywords` ADD CONSTRAINT `brand_id_refs_id_2838ed85` FOREIGN KEY (`brand_id`) REFERENCES `wiki_brand` (`id`);

CREATE TABLE `wiki_item_keywords` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `item_id` integer NOT NULL,
    `wordrel_id` integer NOT NULL,
    `category` varchar(5) NOT NULL,
    `is_effect` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `wiki_item_keywords` ADD CONSTRAINT `wordrel_id_refs_id_179e8a0c` FOREIGN KEY (`wordrel_id`) REFERENCES `api_wordrel` (`id`);
ALTER TABLE `wiki_item_keywords` ADD CONSTRAINT `item_id_refs_id_48b4a9d8` FOREIGN KEY (`item_id`) REFERENCES `wiki_item` (`id`);

CREATE TABLE `wiki_product_keywords` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `product_id` integer NOT NULL,
    `wordrel_id` integer NOT NULL,
    `category` varchar(5) NOT NULL,
    `is_effect` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `wiki_product_keywords` ADD CONSTRAINT `wordrel_id_refs_id_115a7cb1` FOREIGN KEY (`wordrel_id`) REFERENCES `api_wordrel` (`id`);
ALTER TABLE `wiki_product_keywords` ADD CONSTRAINT `product_id_refs_id_bd94c44e` FOREIGN KEY (`product_id`) REFERENCES `wiki_product` (`id`);

CREATE INDEX `wiki_brand_keywords_5afadb1e` ON `wiki_brand_keywords` (`brand_id`);
CREATE INDEX `wiki_brand_keywords_a24ba7e7` ON `wiki_brand_keywords` (`wordrel_id`);

CREATE INDEX `wiki_item_keywords_0a47aae8` ON `wiki_item_keywords` (`item_id`);
CREATE INDEX `wiki_item_keywords_a24ba7e7` ON `wiki_item_keywords` (`wordrel_id`);

CREATE INDEX `wiki_product_keywords_7f1b40ad` ON `wiki_product_keywords` (`product_id`);
CREATE INDEX `wiki_product_keywords_a24ba7e7` ON `wiki_product_keywords` (`wordrel_id`);

COMMIT;
