-- Deploy gaia:api_2016_09_12_create_table_optimizewiki to mysql

BEGIN;

CREATE TABLE `api_tagwiki` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tag_id` integer NOT NULL,
    `itemwiki_id` integer DEFAULT NULL
)
;
ALTER TABLE `api_tagwiki` ADD CONSTRAINT `itemwiki_id_refs_id_12e9628a` FOREIGN KEY (`itemwiki_id`) REFERENCES `api_itemwiki` (`id`);
ALTER TABLE `api_tagwiki` ADD CONSTRAINT `tag_id_refs_id_6756d7a1` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);

CREATE TABLE `api_wikistruct` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `wiki_id` integer NOT NULL,
    `parent_id` integer,
    `struct_level` varchar(5) NOT NULL,
    `sort` integer NOT NULL
)
;
ALTER TABLE `api_wikistruct` ADD CONSTRAINT `wiki_id_refs_id_b676b519` FOREIGN KEY (`wiki_id`) REFERENCES `api_itemwiki` (`id`);
ALTER TABLE `api_wikistruct` ADD CONSTRAINT `parent_id_refs_id_a856a5de` FOREIGN KEY (`parent_id`) REFERENCES `api_wikistruct` (`id`);

CREATE TABLE `api_wikidetailadver` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `image_header` varchar(300) NOT NULL,
    `jump_type` varchar(10) NOT NULL,
    `jump_target` varchar(300) NOT NULL,
    `wiki_id` integer NOT NULL,
    `is_online` bool
)
;
ALTER TABLE `api_wikidetailadver` ADD CONSTRAINT `wiki_id_refs_id_d2d754bc` FOREIGN KEY (`wiki_id`) REFERENCES `api_itemwiki` (`id`);

CREATE TABLE `api_connectwiki` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `wiki_id` integer NOT NULL,
    `connectwiki_id` integer NOT NULL
)
;
ALTER TABLE `api_connectwiki` ADD CONSTRAINT `wiki_id_refs_id_6ed6dc0d` FOREIGN KEY (`wiki_id`) REFERENCES `api_itemwiki` (`id`);
ALTER TABLE `api_connectwiki` ADD CONSTRAINT `connectwiki_id_refs_id_6ed6dc0d` FOREIGN KEY (`connectwiki_id`) REFERENCES `api_itemwiki` (`id`);

CREATE TABLE `api_optimizewiki` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `wiki_id` integer NOT NULL,
    `title` varchar(50) NOT NULL,
    `type` varchar(1) NOT NULL,
    `ordering` integer NOT NULL,
    `is_visible` bool NOT NULL,
    `is_delete` bool NOT NULL,
    `content` longtext
)
;
ALTER TABLE `api_optimizewiki` ADD CONSTRAINT `wiki_id_refs_id_0f27ca23` FOREIGN KEY (`wiki_id`) REFERENCES `api_itemwiki` (`id`);


ALTER TABLE `api_itemwiki`
ADD COLUMN `ache_level` varchar(5) NOT NULL DEFAULT 0,
ADD COLUMN `anesthesia_type` varchar(5) NOT NULL,
ADD COLUMN `show_diary` bool NOT NULL DEFAULT TRUE ,
ADD COLUMN `show_service` bool NOT NULL DEFAULT TRUE,
ADD COLUMN `show_zone` bool NOT NULL DEFAULT TRUE;

alter table api_itemwiki MODIFY `tag_id` integer DEFAULT NULL;

ALTER TABLE `api_wikiadver` MODIFY `tag_id` INTEGER DEFAULT NULL;
ALTER TABLE `api_wikiadver`ADD COLUMN `itemwiki_id`INTEGER DEFAULT NULL;
ALTER TABLE `api_wikiadver` ADD CONSTRAINT `itemwiki_id_refs_id_062dac9f` FOREIGN KEY (`itemwiki_id`) REFERENCES `api_itemwiki` (`id`);
ALTER TABLE `api_wikiadver`ADD COLUMN `is_online`bool DEFAULT FALSE;

COMMIT;
