-- Deploy gaia:api_2016_11_22_create_table_locklist_servicelock to mysql

BEGIN;

CREATE TABLE `api_locklist` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(128) NOT NULL,
    `start_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;

CREATE TABLE `api_servicelock` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `locklist_id` integer NOT NULL,
    `service_id` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    UNIQUE (`locklist_id`, `service_id`)
)
;
ALTER TABLE `api_servicelock` ADD CONSTRAINT `service_id_refs_id_64505414` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_servicelock` ADD CONSTRAINT `locklist_id_refs_id_bf46760a` FOREIGN KEY (`locklist_id`) REFERENCES `api_locklist` (`id`);

CREATE TABLE `api_doctorseckillapplyrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctorseckillapply_id` integer NOT NULL,
    `is_pass` bool NOT NULL,
    `seckill_price` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `person_id` char(32) NOT NULL,
    `comment` varchar(500) NOT NULL
)
;
ALTER TABLE `api_doctorseckillapplyrecord` ADD CONSTRAINT `doctorseckillapply_id_refs_id_ad75695f` FOREIGN KEY (`doctorseckillapply_id`) REFERENCES `api_doctorseckillapply` (`id`);
ALTER TABLE `api_doctorseckillapplyrecord` ADD CONSTRAINT `person_id_refs_id_44f4b1bf` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`);

ALTER TABLE `api_doctorseckillapply` ADD COLUMN `status` varchar(8) NOT NULL DEFAULT '0';
ALTER TABLE `api_doctorseckillapply` ADD COLUMN `created_time` datetime(6) NOT NULL;
ALTER TABLE `api_doctorseckillapply` ADD COLUMN `available_num` INTEGER ;
ALTER TABLE `api_doctorseckillapply` ADD COLUMN `pre_payment_price` INTEGER ;
ALTER TABLE `api_doctorseckillapply` ADD COLUMN `commission` INTEGER ;
ALTER TABLE `api_doctorseckillapply` ADD COLUMN `pass_time` datetime(6) ;
ALTER TABLE `api_doctorseckillapply` ADD COLUMN `latest_apply_time` datetime(6);

COMMIT;
