-- Deploy gaia:api_2017_03_29_add_table_servicecomment to mysql

BEGIN;

CREATE TABLE `api_servicecomment` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `service_id` integer NOT NULL,
    `order_id` varchar(12) NOT NULL,
    `rating` integer NOT NULL,
    `operation_effect` integer NOT NULL,
    `doctor_attitude` integer NOT NULL,
    `hospital_env` integer NOT NULL,
    `content` longtext NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `is_online` bool NOT NULL,
    `with_images` bool NOT NULL,
    `default_rating` bool NOT NULL
)
;
ALTER TABLE `api_servicecomment` ADD CONSTRAINT `service_id_refs_id_d4fbc450` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);
ALTER TABLE `api_servicecomment` ADD CONSTRAINT `order_id_refs_id_625570f7` FOREIGN KEY (`order_id`) REFERENCES `api_order` (`id`);
ALTER TABLE `api_servicecomment` ADD CONSTRAINT `unique_key_order_id` UNIQUE (`order_id`);

CREATE TABLE `api_servicecommentimage` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `service_comment_id` integer NOT NULL,
    `image` varchar(64) NOT NULL
)
;
ALTER TABLE `api_servicecommentimage` ADD CONSTRAINT `service_comment_id_refs_id_e130c4c1` FOREIGN KEY (`service_comment_id`) REFERENCES `api_servicecomment` (`id`);

CREATE TABLE `api_servicecommentoption` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `service_comment_id` integer NOT NULL,
    `option_content` varchar(3) NOT NULL
)
;
ALTER TABLE `api_servicecommentoption` ADD CONSTRAINT `service_comment_id_refs_id_7632c04b` FOREIGN KEY (`service_comment_id`) REFERENCES `api_servicecomment` (`id`);

COMMIT;
