-- Deploy gaia:api_2018_07_06_bd_transfer to mysql

BEGIN;

CREATE TABLE `api_bdtransfer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user` varchar(32) NOT NULL,
    `user_phone` varchar(20) NOT NULL,
    `qq` varchar(16) NOT NULL,
    `wechat` varchar(32) NOT NULL,
    `weibo` varchar(32) NOT NULL,
    `consume_potential_min` integer NOT NULL,
    `consume_potential_max` integer NOT NULL,
    `intention` smallint NOT NULL,
    `source` smallint NOT NULL,
    `potential_assess` smallint NOT NULL,
    `creator` varchar(32) NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `assigner` varchar(32) NOT NULL,
    `last_follow_time` datetime(6),
    `is_assign` bool NOT NULL,
    `assigned_time` datetime(6)
)
;
CREATE TABLE `api_bdtransfer_operationrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransfer_id` integer NOT NULL,
    `operate_user_id` integer NOT NULL,
    `action` smallint NOT NULL,
    `content` varchar(128) NOT NULL,
    `operate_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_bdtransfer_willing_project` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tag_id` integer NOT NULL,
    `start_time` date,
    `end_time` date,
    `comment` varchar(256) NOT NULL,
    `bdtransfer_id` integer NOT NULL
)
;
CREATE TABLE `api_bdtransfer_history_project` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `tag_id` integer NOT NULL,
    `know_time` date,
    `bdtransfer_id` integer NOT NULL
)
;
CREATE TABLE `api_bdtransfer_communicationrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `communication_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `content` varchar(128) NOT NULL,
    `bdtransfer_id` integer NOT NULL
)
;
CREATE TABLE `api_bdtransfer_singlerecord_project` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransfersinglerecord_id` integer NOT NULL,
    `tag_id` integer NOT NULL,
    UNIQUE (`bdtransfersinglerecord_id`, `tag_id`)
)
;
CREATE TABLE `api_bdtransfer_cluetag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(32) NOT NULL UNIQUE,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_bdtransfer_clue_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransfer_id` integer NOT NULL,
    `bdtransfercluetag_id` integer NOT NULL,
    UNIQUE (`bdtransfer_id`, `bdtransfercluetag_id`)
)
;
CREATE TABLE `api_bdtransfer_willing_cities` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `bdtransfer_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL,
    UNIQUE (`bdtransfer_id`, `city_id`)
)
;
CREATE TABLE `api_bdtransfer_singlerecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `single_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `doctor_id` varchar(100) NOT NULL,
    `status` smallint NOT NULL,
    `budan_id` varchar(12),
    `dbtransfer_id` integer NOT NULL
)
;
ALTER TABLE `api_bdtransfer_willing_cities` ADD CONSTRAINT `city_id_refs_id_7e66f0c1` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
ALTER TABLE `api_bdtransfer_clue_tags` ADD CONSTRAINT `bdtransfer_id_refs_id_979c3297` FOREIGN KEY (`bdtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_willing_cities` ADD CONSTRAINT `bdtransfer_id_refs_id_2021c2ef` FOREIGN KEY (`bdtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_operationrecord` ADD CONSTRAINT `operate_user_id_refs_id_98041963` FOREIGN KEY (`operate_user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_bdtransfer_operationrecord` ADD CONSTRAINT `bdtransfer_id_refs_id_b4986c86` FOREIGN KEY (`bdtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_willing_project` ADD CONSTRAINT `bdtransfer_id_refs_id_4a593073` FOREIGN KEY (`bdtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_willing_project` ADD CONSTRAINT `tag_id_refs_id_ac56b952` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
ALTER TABLE `api_bdtransfer_history_project` ADD CONSTRAINT `bdtransfer_id_refs_id_0d17ba34` FOREIGN KEY (`bdtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_history_project` ADD CONSTRAINT `tag_id_refs_id_f6cd29bb` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
ALTER TABLE `api_bdtransfer_communicationrecord` ADD CONSTRAINT `user_id_refs_id_4a313cca` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_bdtransfer_communicationrecord` ADD CONSTRAINT `bdtransfer_id_refs_id_ed25772f` FOREIGN KEY (`bdtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_singlerecord_project` ADD CONSTRAINT `tag_id_refs_id_4b9abaab` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
ALTER TABLE `api_bdtransfer_singlerecord` ADD CONSTRAINT `user_id_refs_id_32cde033` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_bdtransfer_singlerecord` ADD CONSTRAINT `dbtransfer_id_refs_id_723390e5` FOREIGN KEY (`dbtransfer_id`) REFERENCES `api_bdtransfer` (`id`);
ALTER TABLE `api_bdtransfer_singlerecord` ADD CONSTRAINT `doctor_id_refs_id_e1b512d1` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `api_bdtransfer_singlerecord` ADD CONSTRAINT `budan_id_refs_id_2b210a80` FOREIGN KEY (`budan_id`) REFERENCES `api_budan` (`id`);
ALTER TABLE `api_bdtransfer_singlerecord_project` ADD CONSTRAINT `bdtransfersinglerecord_id_refs_id_e0cfbcb5` FOREIGN KEY (`bdtransfersinglerecord_id`) REFERENCES `api_bdtransfer_singlerecord` (`id`);
ALTER TABLE `api_bdtransfer_clue_tags` ADD CONSTRAINT `bdtransfercluetag_id_refs_id_dcf8e565` FOREIGN KEY (`bdtransfercluetag_id`) REFERENCES `api_bdtransfer_cluetag` (`id`);

ALTER TABLE `api_budan` ADD COLUMN `budan_type` smallint NOT NULL;

COMMIT;
