-- Deploy gaia:api_2019_08_02_add_change_face_table to mysql

BEGIN;


CREATE TABLE `api_face_app` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `photo_url` varchar(128) NOT NULL,
    `yong_photo` varchar(128) NOT NULL,
    `old_photo` varchar(128) NOT NULL,
    `laugh_photo` varchar(128) NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_face_puzzle_half_share` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `sharer_face_id` integer NOT NULL,
    `sharer_id` integer NOT NULL,
    `place` integer NOT NULL,
    `sharer_name` varchar(64) NOT NULL,
    `puzzle_type` smallint NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_face_puzzle_half_share` ADD CONSTRAINT `sharer_face_id_refs_id_3a450c26` FOREIGN KEY (`sharer_face_id`) REFERENCES `api_face_app` (`id`);
CREATE TABLE `api_face_together` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `puzzle_share_id` integer,
    `sharer_face_id` integer NOT NULL,
    `participant_face_id` integer NOT NULL,
    `participant_name` varchar(64) NOT NULL,
    `puzzle_type` smallint NOT NULL,
    `puzzle_url` varchar(128) NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_face_together` ADD CONSTRAINT `sharer_face_id_refs_id_ae142883` FOREIGN KEY (`sharer_face_id`) REFERENCES `api_face_app` (`id`);
ALTER TABLE `api_face_together` ADD CONSTRAINT `participant_face_id_refs_id_ae142883` FOREIGN KEY (`participant_face_id`) REFERENCES `api_face_app` (`id`);


CREATE INDEX `api_face_app_1ffdedc6` ON `api_face_app` (`user_id`);
CREATE INDEX `api_face_puzzle_half_share_cbd098a5` ON `api_face_puzzle_half_share` (`sharer_face_id`);
CREATE INDEX `api_face_puzzle_half_share_79016368` ON `api_face_puzzle_half_share` (`sharer_id`);
CREATE INDEX `api_face_together_cbd098a5` ON `api_face_together` (`sharer_face_id`);
CREATE INDEX `api_face_together_fd0854da` ON `api_face_together` (`participant_face_id`);
COMMIT;
