-- Deploy gaia:doctor_2017_02_14_doctor_register to mysql

BEGIN;

CREATE TABLE `doctor_doctorregisterlicence` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_register_id` integer NOT NULL,
    `type` integer NOT NULL,
    `image_url` varchar(256) NOT NULL
)
;
ALTER TABLE `doctor_doctorregisterlicence` ADD CONSTRAINT `doctor_register_id_refs_id_6e9b672f` FOREIGN KEY (`doctor_register_id`) REFERENCES `doctor_doctorregister` (`id`);
CREATE TABLE `doctor_doctorregisterrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_register_id` integer NOT NULL,
    `status` integer NOT NULL,
    `reject_reason` varchar(500),
    `handler_id` char(32),
    `created_at` datetime(6) NOT NULL,
    `content` longtext NOT NULL
)
;
ALTER TABLE `doctor_doctorregisterrecord` ADD CONSTRAINT `handler_id_refs_id_d3f3f503` FOREIGN KEY (`handler_id`) REFERENCES `api_person` (`id`);
ALTER TABLE `doctor_doctorregisterrecord` ADD CONSTRAINT `doctor_register_id_refs_id_036272a4` FOREIGN KEY (`doctor_register_id`) REFERENCES `doctor_doctorregister` (`id`);

CREATE TABLE `doctor_doctorregisteragreement` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_register_id` integer NOT NULL,
    `image_url` varchar(256) NOT NULL
)
;
ALTER TABLE `doctor_doctorregisteragreement` ADD CONSTRAINT `doctor_register_id_refs_id_625f75eb` FOREIGN KEY (`doctor_register_id`) REFERENCES `doctor_doctorregister` (`id`);


CREATE TABLE `doctor_doctorlicence` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100),
    `hospital_id` varchar(100),
    `type` integer NOT NULL,
    `image_url` varchar(256) NOT NULL
)
;
ALTER TABLE `doctor_doctorlicence` ADD CONSTRAINT `doctor_id_refs_id_185e187f` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `doctor_doctorlicence` ADD CONSTRAINT `hospital_id_refs_id_fe67c4b6` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);

CREATE TABLE `doctor_doctoreditrecord` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `status` integer NOT NULL,
    `reject_reason` varchar(100),
    `handler_id` char(32),
    `created_at` datetime(6) NOT NULL,
    `content` longtext NOT NULL
)
;
ALTER TABLE `doctor_doctoreditrecord` ADD CONSTRAINT `handler_id_refs_id_f5be7453` FOREIGN KEY (`handler_id`) REFERENCES `api_person` (`id`);
ALTER TABLE `doctor_doctoreditrecord` ADD CONSTRAINT `doctor_id_refs_id_d867b582` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);


ALTER TABLE `doctor_doctorregister` 
ADD COLUMN `city_id` varchar(40),
ADD COLUMN `address` varchar(200),
ADD COLUMN `hospital_type` varchar(1),
ADD COLUMN `related_hospital_id` varchar(100),
ADD COLUMN `area_type` integer,
ADD COLUMN `status` integer NOT NULL,
ADD COLUMN `handler_id` char(32),
ADD COLUMN `is_agreement_checked` bool NOT NULL,
MODIFY `email` varchar(100),
MODIFY `assist_phone` varchar(20),
MODIFY `business_licence` varchar(400),
MODIFY `practice_licence` varchar(400);

ALTER TABLE `doctor_doctorregister` ADD CONSTRAINT `city_id_refs_id_cbabbd94` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);
ALTER TABLE `doctor_doctorregister` ADD CONSTRAINT `related_hospital_id_refs_id_f94d246f` FOREIGN KEY (`related_hospital_id`) REFERENCES `api_hospital` (`id`);
ALTER TABLE `doctor_doctorregister` ADD CONSTRAINT `handler_id_refs_id_abae4307` FOREIGN KEY (`handler_id`) REFERENCES `api_person` (`id`);


ALTER TABLE `api_doctor` 
ADD COLUMN `area_type` integer,
ADD COLUMN `assist_phone` varchar(20),
ADD COLUMN `status` integer NOT NULL,
ADD COLUMN `last_edit_time` datetime(6) NOT NULL,
MODIFY `doc_email` varchar(100),
MODIFY `doc_birthday` varchar(40),
MODIFY `business_licence` varchar(400),
MODIFY `practice_licence` varchar(400);


COMMIT;
