-- Deploy gaia:hippo_20170110_add_hospital_info to mysql

BEGIN;

CREATE TABLE `hippo_hospital_instrument` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hospital_id` varchar(100) NOT NULL UNIQUE,
    `intro` longtext NOT NULL,
    `content` longtext NOT NULL
);
ALTER TABLE `hippo_hospital_instrument` ADD CONSTRAINT `hospital_id_refs_id_12c2e80c` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);

CREATE TABLE `hippo_hospital_video` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hospital_id` varchar(100) NOT NULL UNIQUE,
    `video_url` varchar(128) NOT NULL,
    `video_pic` varchar(128) NOT NULL,
    `persistentId` varchar(128) NOT NULL,
    `persistent_status` integer NOT NULL,
    `water_url` varchar(128) NOT NULL
);
ALTER TABLE `hippo_hospital_video` ADD CONSTRAINT `hospital_id_refs_id_67c18632` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);

CREATE TABLE `hippo_hospital_recommendservice` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hospital_id` varchar(100) NOT NULL,
    `service_id` integer NOT NULL
);
ALTER TABLE `hippo_hospital_recommendservice` ADD CONSTRAINT `hospital_id_refs_id_c975987e` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);

CREATE TABLE `hippo_hospital_recommenddoctor` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `hospital_id` varchar(100) NOT NULL,
    `doctor_id` varchar(100) NOT NULL
);
ALTER TABLE `hippo_hospital_recommenddoctor` ADD CONSTRAINT `hospital_id_refs_id_df40f1d4` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);

COMMIT;
