-- Deploy gaia:maidan_2016_10_18_maidan_init to mysql

BEGIN;
CREATE TABLE `maidan_order` (
    `id` varchar(12) NOT NULL PRIMARY KEY,
    `maidan_name` varchar(100) NOT NULL,
    `tag_names` varchar(100) NOT NULL,
    `status` varchar(20) NOT NULL,
    `maidan_price_cent` integer NOT NULL,
    `payment_cent` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `payment_id` varchar(20) NOT NULL,
    `payment_channel` varchar(3) NOT NULL,
    `payment_time` datetime(6),
    `user_id` integer NOT NULL,
    `source` varchar(1) NOT NULL,
    `is_settled` bool NOT NULL,
    `settled_time` datetime(6),
    `doctor_id` varchar(100) NOT NULL,
    `doctor_discount_rate` integer NOT NULL,
    `doctor_discount_cent` integer NOT NULL,
    `gengmei_offers_rate` integer NOT NULL,
    `gengmei_offers_cent` integer NOT NULL,
    `discount_cent` integer NOT NULL
)
;
ALTER TABLE `maidan_order` ADD CONSTRAINT `doctor_id_refs_id_6433ffd3` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `maidan_order` ADD CONSTRAINT `user_id_refs_id_84869b34` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `maidan_ordersnapshot` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `maidan_order_id` varchar(12) NOT NULL UNIQUE,
    `maidan_name` varchar(100) NOT NULL,
    `tag_names` varchar(100) NOT NULL,
    `doctor_portrait` varchar(300) NOT NULL,
    `maidan_price_cent` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `user_id` integer NOT NULL,
    `source` varchar(1) NOT NULL,
    `doctor_id` varchar(100) NOT NULL,
    `doctor_discount_rate` integer NOT NULL,
    `doctor_discount_cent` integer NOT NULL,
    `gengmei_offers_rate` integer NOT NULL,
    `gengmei_offers_cent` integer NOT NULL,
    `discount_rate` integer NOT NULL,
    `hospital_id` varchar(100)
)
;
ALTER TABLE `maidan_ordersnapshot` ADD CONSTRAINT `doctor_id_refs_id_2a0cc54b` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
ALTER TABLE `maidan_ordersnapshot` ADD CONSTRAINT `maidan_order_id_refs_id_806ef433` FOREIGN KEY (`maidan_order_id`) REFERENCES `maidan_order` (`id`);
ALTER TABLE `maidan_ordersnapshot` ADD CONSTRAINT `user_id_refs_id_561ec9fe` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `maidan_ordersnapshot` ADD CONSTRAINT `hospital_id_refs_id_f8ca04eb` FOREIGN KEY (`hospital_id`) REFERENCES `api_hospital` (`id`);
CREATE TABLE `maidan_payment` (
    `id` varchar(30) NOT NULL PRIMARY KEY,
    `name` varchar(100) NOT NULL,
    `total_amount_cent` integer NOT NULL,
    `maidan_order_id` varchar(30) NOT NULL,
    `created_at` datetime(6) NOT NULL,
    `expired_at` datetime(6) NOT NULL,
    `status` varchar(3) NOT NULL,
    `payment_time` datetime(6),
    `channel` varchar(3) NOT NULL,
    `channel_transaction_id` varchar(50) NOT NULL,
    `notify_info` longtext NOT NULL
)
;
CREATE TABLE `maidan_order_operation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `order_id` varchar(12) NOT NULL,
    `operator_id` char(32) NOT NULL,
    `optype` integer NOT NULL,
    `role` integer NOT NULL,
    `source` varchar(1) NOT NULL,
    `operate_at` datetime(6)
)
;
ALTER TABLE `maidan_order_operation` ADD CONSTRAINT `operator_id_refs_id_1621955a` FOREIGN KEY (`operator_id`) REFERENCES `api_person` (`id`);
ALTER TABLE `maidan_order_operation` ADD CONSTRAINT `order_id_refs_id_f51202b9` FOREIGN KEY (`order_id`) REFERENCES `maidan_order` (`id`);
CREATE TABLE `maidan_statement` (
    `id` varchar(15) NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL,
    `status` integer NOT NULL,
    `original_amount_cent` integer NOT NULL,
    `settle_amount_cent` integer NOT NULL,
    `created_at` datetime(6) NOT NULL,
    `updated_at` datetime(6) NOT NULL,
    `statement_date` integer NOT NULL,
    `settle_snapshot` longtext NOT NULL,
    `operator_id` char(32),
    UNIQUE (`doctor_id`, `statement_date`)
)
;
ALTER TABLE `maidan_statement` ADD CONSTRAINT `operator_id_refs_id_066d6725` FOREIGN KEY (`operator_id`) REFERENCES `api_person` (`id`);
ALTER TABLE `maidan_statement` ADD CONSTRAINT `doctor_id_refs_id_e91bab5e` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `maidan_orderstatementrelationship` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `statement_id` varchar(15) NOT NULL,
    `order_id` varchar(12) NOT NULL UNIQUE
)
;
ALTER TABLE `maidan_orderstatementrelationship` ADD CONSTRAINT `order_id_refs_id_deebec98` FOREIGN KEY (`order_id`) REFERENCES `maidan_order` (`id`);
ALTER TABLE `maidan_orderstatementrelationship` ADD CONSTRAINT `statement_id_refs_id_5a378619` FOREIGN KEY (`statement_id`) REFERENCES `maidan_statement` (`id`);
CREATE TABLE `maidan_setting` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `doctor_id` varchar(100) NOT NULL UNIQUE,
    `is_open` bool NOT NULL,
    `doctor_discount_rate` integer NOT NULL,
    `discount_rate` integer NOT NULL,
    `gengmei_offers_rate` integer NOT NULL
)
;
ALTER TABLE `maidan_setting` ADD CONSTRAINT `doctor_id_refs_id_bf343528` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);
CREATE TABLE `maidan_settingapply` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `last_modify_time` datetime(6),
    `doctor_id` varchar(100) NOT NULL UNIQUE,
    `is_open` bool NOT NULL,
    `doctor_discount_rate` integer NOT NULL,
    `status` varchar(2) NOT NULL,
    `last_review_time` datetime(6)
)
;
ALTER TABLE `maidan_settingapply` ADD CONSTRAINT `doctor_id_refs_id_688aefea` FOREIGN KEY (`doctor_id`) REFERENCES `api_doctor` (`id`);

COMMIT;
