-- Deploy gaia:mypushtask to mysql

BEGIN;

-- XXX Add DDLs here.
DROP TABLE IF EXISTS `api_pushtask2`;
CREATE TABLE `api_pushtask2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `heading` varchar(512) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `subheading` varchar(512) CHARACTER SET utf8mb4 NOT NULL DEFAULT '',
  `platform` int(11) NOT NULL,
  `pushtype` varchar(256) NOT NULL,
  `pushtime` datetime(6) DEFAULT NULL,
  `usertype` int(11) DEFAULT NULL,
  `pushvalue` varchar(512) NOT NULL,
  `online` tinyint(1) NOT NULL,
  `showname` tinyint(1) NOT NULL,
  `message` varchar(512) NOT NULL,
  `status` int(11) NOT NULL,
  `created_time` datetime(6) NOT NULL,
  `approver_id` int(11) DEFAULT NULL,
  `creator_id` int(11) DEFAULT NULL,
  `image` varchar(200) NOT NULL,
  `linkid` varchar(512) NOT NULL,
  `url` varchar(512) NOT NULL,
  `jiguang_id` varchar(128) DEFAULT NULL,
  `approver_status` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `api_pushtask2_approver_id_5c387e1a743e39f2_fk_auth_user_id` (`approver_id`),
  KEY `api_pushtask2_creator_id_38aeaf4d0dc7c7e_fk_auth_user_id` (`creator_id`),
  CONSTRAINT `api_pushtask2_approver_id_5c387e1a743e39f2_fk_auth_user_id` FOREIGN KEY (`approver_id`) REFERENCES `auth_user` (`id`),
  CONSTRAINT `api_pushtask2_creator_id_38aeaf4d0dc7c7e_fk_auth_user_id` FOREIGN KEY (`creator_id`) REFERENCES `auth_user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for api_pushtask2_city
-- ----------------------------
DROP TABLE IF EXISTS `api_pushtask2_city`;
CREATE TABLE `api_pushtask2_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pushtask2_id` int(11) NOT NULL,
  `city_id` varchar(40) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pushtask2_id` (`pushtask2_id`,`city_id`),
  KEY `api_pushtask2_city_city_id_6a27795a0aa762f9_fk_home_city_id` (`city_id`),
  CONSTRAINT `api_pushtask2__pushtask2_id_40a0ef32a6becd2a_fk_api_pushtask2_id` FOREIGN KEY (`pushtask2_id`) REFERENCES `api_pushtask2` (`id`),
  CONSTRAINT `api_pushtask2_city_city_id_6a27795a0aa762f9_fk_home_city_id` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for api_pushtask2_pushtags
-- ----------------------------
DROP TABLE IF EXISTS `api_pushtask2_pushtags`;
CREATE TABLE `api_pushtask2_pushtags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pushtask2_id` int(11) NOT NULL,
  `tag_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pushtask2_id` (`pushtask2_id`,`tag_id`),
  KEY `api_pushtask2_pushtags_tag_id_39f1e0231310a365_fk_home_tag_id` (`tag_id`),
  CONSTRAINT `api_pushtask2_p_pushtask2_id_adee44d8ea585bc_fk_api_pushtask2_id` FOREIGN KEY (`pushtask2_id`) REFERENCES `api_pushtask2` (`id`),
  CONSTRAINT `api_pushtask2_pushtags_tag_id_39f1e0231310a365_fk_home_tag_id` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for api_pushtask2_region
-- ----------------------------
DROP TABLE IF EXISTS `api_pushtask2_region`;
CREATE TABLE `api_pushtask2_region` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pushtask2_id` int(11) NOT NULL,
  `region_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pushtask2_id` (`pushtask2_id`,`region_id`),
  KEY `api_pushtask2_regio_region_id_41cd1c2a8b6dc689_fk_home_region_id` (`region_id`),
  CONSTRAINT `api_pushtask2__pushtask2_id_66ae17d782a52d3d_fk_api_pushtask2_id` FOREIGN KEY (`pushtask2_id`) REFERENCES `api_pushtask2` (`id`),
  CONSTRAINT `api_pushtask2_regio_region_id_41cd1c2a8b6dc689_fk_home_region_id` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for api_pushuser
-- ----------------------------
DROP TABLE IF EXISTS `api_pushuser`;
CREATE TABLE `api_pushuser` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `device` varchar(256) NOT NULL,
  `pushtask_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `api_pushuser_4aea0d1b` (`pushtask_id`),
  CONSTRAINT `api_pushuser_pushtask_id_64abcbe43d710c39_fk_api_pushtask2_id` FOREIGN KEY (`pushtask_id`) REFERENCES `api_pushtask2` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;


ALTER TABLE api_pushtask2 CHANGE `heading` `heading` VARCHAR(512) CHARACTER SET utf8mb4 NOT NULL DEFAULT '';
ALTER TABLE api_pushtask2 CHANGE `subheading` `subheading` VARCHAR(512) CHARACTER SET utf8mb4 NOT NULL DEFAULT '';

COMMIT;
