-- Deploy gaia:pay_2016_07_05_add_installment_table to mysql

BEGIN;

CREATE TABLE `pay_borrower` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `partner` integer NOT NULL,
    `person_id` char(32) NOT NULL,
    `third_uid` varchar(64) NOT NULL,
    `third_password` varchar(98) NOT NULL,
    `name` varchar(34) NOT NULL,
    `card_id` varchar(54) NOT NULL,
    `phone` varchar(38) NOT NULL,
    `marriage` varchar(10) NOT NULL,
    `gender` varchar(3) NOT NULL,
    `age` integer NOT NULL,
    `education` varchar(10) NOT NULL,
    `province` varchar(20) NOT NULL,
    `city` varchar(20) NOT NULL,
    `district` varchar(40) NOT NULL,
    `address` varchar(64) NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
ALTER TABLE `pay_borrower` ADD CONSTRAINT `person_id_refs_id_a61862dc` FOREIGN KEY (`person_id`) REFERENCES `api_person` (`id`);
CREATE TABLE `pay_bank` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `partner` integer NOT NULL,
    `name` varchar(32) NOT NULL,
    `phone` varchar(16) NOT NULL,
    `code` varchar(10) NOT NULL,
    `logo` varchar(400) NOT NULL,
    `description` varchar(32) NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
CREATE TABLE `pay_borrower_bind` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `partner` integer NOT NULL,
    `bank_id` integer NOT NULL,
    `borrower_id` integer NOT NULL,
    `name` varchar(34) NOT NULL,
    `phone` varchar(38) NOT NULL,
    `card_code` varchar(38) NOT NULL,
    `province` varchar(32) NOT NULL,
    `city` varchar(32) NOT NULL,
    `sms_code` varchar(10) NOT NULL,
    `ticket` varchar(64) NOT NULL,
    `created_time` datetime(6) NOT NULL
)
;
ALTER TABLE `pay_borrower_bind` ADD CONSTRAINT `borrower_id_refs_id_d5f8311a` FOREIGN KEY (`borrower_id`) REFERENCES `pay_borrower` (`id`);
ALTER TABLE `pay_borrower_bind` ADD CONSTRAINT `bank_id_refs_id_207fcde6` FOREIGN KEY (`bank_id`) REFERENCES `pay_bank` (`id`);
CREATE TABLE `pay_image` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `partner` integer NOT NULL,
    `borrower_id` integer NOT NULL,
    `image_type` integer NOT NULL,
    `url` varchar(400) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `deleted` bool NOT NULL
)
;
ALTER TABLE `pay_image` ADD CONSTRAINT `borrower_id_refs_id_f5453585` FOREIGN KEY (`borrower_id`) REFERENCES `pay_borrower` (`id`);
CREATE TABLE `pay_relative` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `partner` integer NOT NULL,
    `borrower_id` integer NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `deleted` bool NOT NULL,
    `name` varchar(34) NOT NULL,
    `phone` varchar(38) NOT NULL,
    `relationship` varchar(10) NOT NULL,
    `relation_type` integer NOT NULL
)
;
ALTER TABLE `pay_relative` ADD CONSTRAINT `borrower_id_refs_id_736235e8` FOREIGN KEY (`borrower_id`) REFERENCES `pay_borrower` (`id`);
CREATE TABLE `pay_installment` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `partner` integer NOT NULL,
    `settlement_id` varchar(12) NOT NULL,
    `borrower_id` integer NOT NULL,
    `bind_bank_id` integer NOT NULL,
    `periods` integer NOT NULL,
    `period_repay` integer NOT NULL,
    `third_loan_id` varchar(64) NOT NULL,
    `third_loan_order_id` varchar(64) NOT NULL,
    `status` integer NOT NULL,
    `first_repay_time` datetime(6),
    `confirm_time` datetime(6),
    `refund_time` datetime(6),
    `audit_time` datetime(6),
    `audit_description` varchar(128) NOT NULL,
    `apply_time` datetime(6) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `supply_code` varchar(5) NOT NULL
)
;
ALTER TABLE `pay_installment` ADD CONSTRAINT `borrower_id_refs_id_ae75e484` FOREIGN KEY (`borrower_id`) REFERENCES `pay_borrower` (`id`);
ALTER TABLE `pay_installment` ADD CONSTRAINT `settlement_id_refs_id_d5f49b82` FOREIGN KEY (`settlement_id`) REFERENCES `api_settlement` (`id`);
ALTER TABLE `pay_installment` ADD CONSTRAINT `bind_bank_id_refs_id_14f2f973` FOREIGN KEY (`bind_bank_id`) REFERENCES `pay_borrower_bind` (`id`);

COMMIT;
