# coding=utf-8
from __future__ import absolute_import, unicode_literals, print_function

from talos.models.diary import Diary
from ..utils import gaia_gql_call
from gql.types.gaia import *
import graphene_django
from gmgql import RemoteFKField


class DiaryType(graphene_django.DjangoObjectType):
    class Meta:
        model = Diary

    service = RemoteFKField(ServiceType, fk_model=Diary, fk_field_name='service_id',
                            remote_func=gaia_gql_call, remote_list_api_field='services')
    doctor = RemoteFKField(DoctorType, fk_model=Diary, fk_field_name='doctor_id',
                           remote_func=gaia_gql_call, remote_list_api_field='doctors')

