# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function


class ObjFromDict(object):
    """wrap a dict, get key by dot syntax."""

    def __init__(self, d):
        assert isinstance(d, dict)
        for a, b in d.items():
            if isinstance(b, (list, tuple)):
                setattr(self, a, [ObjFromDict(x) if isinstance(x, dict) else x for x in b])
            else:
                setattr(self, a, ObjFromDict(b) if isinstance(b, dict) else b)


def convert_to_type_or(value, to_type, default=None):
    """if value is boolean true, convert to to_type else default."""
    return value and to_type(value) or default
