# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from gm_types.gaia import DIARY_OPERATE

from .diary import Diary


class DiaryOperate(models.Model):
    """
    日记本操作历史
    """

    class Meta:
        verbose_name = u'日记本操作'
        verbose_name_plural = u'日记本操作'
        db_table = 'api_diaryoperate'
        app_label = 'talos'

    diary = models.ForeignKey(Diary, related_name='diary_operations')
    operate_time = models.DateTimeField(auto_now_add=True, verbose_name=u'修改时间')
    operation = models.CharField(verbose_name=u'对日记本的操作', max_length=1, choices=DIARY_OPERATE)
    topic = models.CharField(verbose_name=u'帖子的标记', max_length=30)
