# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from talos.services.user import UserService

from .topicreply import TopicReply


class TopicReplyVote(models.Model):
    """
    赞一级评论
    """

    class Meta:
        unique_together = ('user_id', 'topic_reply')
        app_label = 'talos'
        db_table = 'api_topicreplyvote'

    user_id = models.IntegerField(verbose_name=u'用户外键id')
    topic_reply = models.ForeignKey(TopicReply, verbose_name=u"一级评论")
    vote_time = models.DateTimeField(auto_now_add=True, verbose_name=u"点赞时间")

    # TODO: db clean
    # user = models.ForeignKey(User, verbose_name=u"用户")

    @property
    def user(self):
        return UserService.get_user_by_user_id(self.user_id)
