# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.conf import settings
from django.db import models

from gm_types.gaia import VIDEO_CODE_STATUS

from talos.libs.image_utils import get_full_path

from .topic import Problem


class Video(models.Model):
    class Meta:
        db_table = 'api_topic_video'
        app_label = 'talos'

    topic = models.OneToOneField(Problem, default=None, null=True, related_name="video")
    video_url = models.CharField(max_length=128, verbose_name=u'视屏地址')
    video_pic = models.CharField(max_length=128, verbose_name=u'视屏封面')
    persistentId = models.CharField(max_length=128, verbose_name=u'七牛视频处理id')
    persistent_status = models.IntegerField(default=VIDEO_CODE_STATUS.NOSTART, verbose_name=u"七牛状态", db_index=True)
    water_url = models.CharField(max_length=128, verbose_name=u'水印视屏地址')

    def get_video_info(self):
        if self.video_pic:
            video_pic = get_full_path(self.video_pic, '-w')
        else:
            video_pic = settings.VIDEO_HOST + self.video_url + settings.VIDEO_PIC_URL

        if self.water_url:
            video_url = self.water_url
        else:
            video_url = self.video_url

        return {
            'video_url': settings.VIDEO_HOST + video_url,
            'video_pic': video_pic
        }

    @classmethod
    def cleaned_video_url(cls, video_url):
        return video_url.replace(settings.VIDEO_HOST, '')
