# -*- coding: utf8 -*-

from __future__ import unicode_literals, absolute_import, print_function


from gm_types.gaia import PROBLEM_FLAG_CHOICES
from talos.models.diary import Diary
from talos.backbone.rpc import bind


# todo 无调用 180315
@bind('talos/diary/service_related_diary_amount')
def get_service_related_diary_amount(service_id):
    amount = Diary.objects.filter(
        service_id=service_id,
        topics__isnull=False,
        topics__flag=PROBLEM_FLAG_CHOICES.NORMAL,
        topics__is_online=True,
    ).distinct().count()
    return amount
