#!/usr/bin/env python2
# -*- coding: utf-8 -*-
from django.conf import settings
from django.core.management.base import BaseCommand, CommandError
from trans2es.utils.es import get_es, reindex

class Command(BaseCommand):
    args = ''
    help = 'elasticsearch reindex'

    from optparse import make_option
    option_list = BaseCommand.option_list + ( 
        make_option('-f', '--from', dest='from_index', help='index name to dump from', metavar='FROM'),
        make_option('-t', '--to', dest='to_index', help='index name to dump to', metavar='TO'),
    )

    def handle(self, *args, **options):
        if not options['from_index'] or not options['to_index']:
            raise CommandError('"from index" and "to index" must be both specified')

        es = get_es()
        reindex(es=es, old_index=options['from_index'], new_index=options['to_index'])

