from api.models.ranklist import RankBoard
from api.business.tag import TagControl
from .es import tzlc

def get_board(instance):
    b = instance
    res = {
        "id":b.id,
        "title":b.title,
        "type":b.type,
        "describe":b.describe,
        "is_online":b.is_online,
        "rank":b.rank
    }

    # closure tags
    closure_tags = TagControl.get_ancestors(
        initial_set = b.data_tags.filter(is_online=True),
        exclude_init = False,
        is_online_only = True)
    res['closure_tag_ids'] = [t.id for t in closure_tags]
    res['closure_tags'] = [t.name for t in closure_tags]
    city_tags = b.city_tag_ids()
    region_tag_ids = b.region_city_tag_ids()
    res['city_tag_ids'] = city_tags
    res["region_tag_ids"] = region_tag_ids
    if len(city_tags) == 0 and len(region_tag_ids) ==0:
        res['is_whole_country'] = True
    else:
        res['is_whole_country'] = False
    res['create_time'] = tzlc(b.create_time)
    return res
