# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


from ..core.model_event import ModelDataMonitor, EventHandler
from .queue import table_event_enqueue

import api.models as am
import answer.models as aw

class RedisPushEventHandler(EventHandler):

    def handle_event(self, event):
        table_event_enqueue(event)


mdm = ModelDataMonitor(RedisPushEventHandler())


monitored_model_list = [
    am.AdvertiseManagement,
    am.BodyPart,
    am.BodyPartSubItem,
    am.City,
    # am.Diary,
    # am.DiaryCheck,
    # am.DiaryRank,
    # am.DiaryVote,
    am.Doctor,
    am.DoctorTag,
    am.Hospital,
    am.ItemWiki,
    am.Message,
    am.PeriodHospital,
    # am.Problem,
    # am.ProblemTag,
    am.Province,
    am.Service,
    am.ServiceItem,
    am.ServiceItemPrice,
    am.ServiceRecommend,
    am.ServiceTag,
    am.SKUPriceRule,
    am.SmartRank,
    am.SpecialItem,
    am.Tag,
    am.TicketsResult,
    # am.TopicImage,
    # am.TopicReply,
    # am.TopicVote,
    # am.TopicRankingScore,
    am.User,
    am.UserExtra,
    # am.Video,
    am.Order,

    aw.Answer,
    aw.Question,
    aw.QuestionTag,
]


for m in monitored_model_list:
    mdm.add_model(m)
