# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


from rpc.decorators import bind
from ..core.model_event import DataChangeEvent
from .queue import table_event_enqueue


@bind('api/data_sync/event/post')
def post_event(event):
    event_object = DataChangeEvent.from_dict(event)
    table_event_enqueue(event_object)


@bind('api/data_sync/event/post_list')
def post_event_list(event_list):
    for el in event_list:
        event_object = DataChangeEvent.from_dict(el)
        table_event_enqueue(event_object)

