# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import

import functools


def keyword_argument_only(func):
    @functools.wraps(func)
    def wrapper(**kwargs):
        return func(**kwargs)

    return wrapper


import time


class TimeIt(object):
    def __init__(self, func):
        self._func = func

    def __call__(self, *args, **kwargs):
        start_time = time.time()
        result = self._func(*args, **kwargs)
        end_time = time.time()
        print('time: {}'.format(end_time - start_time))
        return result
