#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   zhangxiaolin
#   E-mail  :   petelin1120@gmail.com
#   Date    :   17/10/18 10:55
#   Desc    :   订单工具函数, 所有model通用的.


def get_refund_no(order):
    from gm_types.gaia import PAYMENT_CHANNEL
    from pay.models import WechatRefund, ApplePayRefund, AlipayRefund
    if order.payment_channel == PAYMENT_CHANNEL.ALIPAY:
        alipay_refund = AlipayRefund.objects.filter(order_no=order.id, trade_status='SUCCESS').values_list('batch_no', flat=True)
        return ','.join(alipay_refund)
    elif order.payment_channel == PAYMENT_CHANNEL.WECHAT:
        wechat_refund = WechatRefund.objects.filter(order_no=order.id, err_code='').values_list('out_refund_no', flat=True)
        return ','.join(wechat_refund)
    elif order.payment_channel == PAYMENT_CHANNEL.APPLEPAY:
        apple_refund = ApplePayRefund.objects.filter(order_no=order.id, sta_refund='2').values_list('no_refund', flat=True)
        return ','.join(apple_refund)
    else:
        return None
