# coding:utf-8
import re


def is_valid_phone(phone):
    """
    international mobile phone number regex.
    :param phone:
    :return:
    """
    return re.compile('^(\+?\d{1,3}[- ]?)?\d{7,16}$').match(phone)


def format_phone(phone):
    """
    if the phone number is national, strip the "+86" prefix.
    :param phone:
    :return:
    """
    if not phone:
        return phone
    phone = phone.strip()
    if len(phone) == 13 and phone.startswith('86'):
        return phone[2:]

    if phone.startswith('+86'):
        return phone[3:]

    return phone


