from django.shortcuts import render

# Create your views here.
from rpc.decorators import bind
from verita.models import WeChatRoomConfig, WechatRoom


@bind('api/verita/get_room_info')
def get_room_info(type_id):
    config = WeChatRoomConfig.objects.using('verita').get(id=type_id)
    room = WechatRoom.objects.using('verita').filter(room_type=config, person_num__lt=95).first()
    if room:
        return {
            'pic': room.qrcode,
            'text': config.transfer
        }
    else:
        return {
            'pic': '',
            'text': ''
        }
