#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/01/31 11:03:35
#   Desc    :   物品相关逻辑
#

from gm_types.wiki.enum import PRODUCT_IMAGE_TYPE

from wiki.models.product import ProductParams


def product_cover_image(product):
    image = product.images.filter(image_type=PRODUCT_IMAGE_TYPE.PRODUCT).first()
    return image.image_url if image else ''


def get_product_params_type_by_type(product_id, type):
    """
    根据物品ID，参数类型，获取参数类型
    :param product_id:
    :param type:
    :return:
    """
    params = ProductParams.objects.filter(product_id=product_id, params_type=type).first()
    return params.params_message if params else ''

def product_brand_info(product):
    result = {}
    brand = product.brand
    if brand and brand.is_online:
        result = {
            'id': brand.id,
            'name': brand.name,
            'description': brand.description,
            'theory': brand.theory,
            'company': brand.company,
            'market_time': brand.market_time
        }
    return result
