# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models
from django.db.models import CharField, TextField, DateTimeField, BooleanField
from django.db.models import IntegerField, ForeignKey

from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.wiki import NEW_WIKI_WORDREL_CATEGORY

from api.models.wordrel import WordRel


class Brand(models.Model):
    class Meta:
        verbose_name = u'品牌'
        db_table = 'wiki_brand'

    name = CharField(u'项目介绍', max_length=48)
    image_url = ImgUrlField(u'图片地址', max_length=128, img_type=IMG_TYPE.ITEMWIKI)
    description = TextField(u'品牌简介')
    theory = TextField(u'药品原理')
    company = CharField(u'品牌公司', max_length=48)
    market_time = CharField(u'上市时间', max_length=48)
    is_online = BooleanField(u'是否上线', default=True)
    create_time = DateTimeField(u'创建时间', auto_now_add=True)

    soyoung_id = IntegerField(u'新氧id', default=0)


class BrandRelationKeyWords(models.Model):
    class Meta:
        verbose_name = '品牌百科 关联的关键词'
        db_table = 'wiki_brand_keywords'

    brand = ForeignKey(Brand, related_name='words')
    wordrel = ForeignKey(WordRel, verbose_name=u'关键字')
    category = CharField(verbose_name=u'分类', max_length=5, choices=NEW_WIKI_WORDREL_CATEGORY)
    is_effect = BooleanField(verbose_name=u'是否有效', default=True)
    created_time = DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    updated_time = DateTimeField(verbose_name=u'最后更新时间', auto_now=True)
