#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__: vv
# Date: 2019/11/5

import os
import sys
import time
import yop_security_utils
import yop_request_sdk as yp2util_rsa

import django
BASE_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

sys.path.append(BASE_DIR)

os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'gaia.settings')
django.setup()

from django.conf import settings

api = '/rest/v1.0/std/trade/order'
params = {
    'orderId': '1402350',
    'orderAmount': '0.01',
    'merchantNo': '10030767124',
    'parentMerchantNo': '10030767124',
    'notifyUrl': 'http://exchange.env.wanmeizhensuo.com/paas/gateway/payment/payment/yee/callback',  # 回调地址
    'redirectUrl': 'http://www.baidu.com',  # 支付成功跳转地址
    'goodsParamExt': '{"goodsDesc": "\\u8fd9\\u662f\\u4e00\\u4e2a\\u6d4b\\u8bd5\\u5546\\u54c1", "goodsName": "\\u8fd9\\u662f\\u4e00\\u4e2a\\u6d4b\\u8bd5\\u5546\\u54c1"}',
}


def get_token():
    """
    获取token
    :return:
    """
    token = ''
    result, code = yp2util_rsa.restful_param(api=api, params=params)
    if code != 'OPR00000':
        print("获取失败!")
    else:
        token = result['token']
    return token, result


def sign_data(data):
    """
    https://open.yeepay.com/docs/e-commerceprotocols/5afd43472181f8275762d7da.html
    1. sorted_rules 参数都必须传递, 默认为空串
    2. sorted_rules 顺序不能改变
    :param data:
    :return:
    """
    unsigned_string = ""
    sorted_rules = (
        (1, "merchantNo"),
        (2, "token"),
        (3, "timestamp"),
        (4, "directPayType"),
        (5, "cardType"),
        (6, "userNo"),
        (7, "userType"),
        (8, "ext"),
    )
    for _, param in sorted_rules:
        value = data.get(param, "")
        if param == "ext" and not value:
            value = {
                "appId": "",
                "openId": "",
                "clientId": ""
            }
        unsigned_string += "%s=%s&" % (param, value)

    unsigned_string = unsigned_string.strip("&")

    sign = yop_security_utils.sign_rsa(unsigned_string, private_key=settings.YIBAO_PRIVATE_KEY)
    print('回调前base64: ', sign)
    signed_string = "sign=" + sign + '$SHA256' + '&' + unsigned_string
    return signed_string


def gen_url():
    """
    生成支付链接
    :return:
    """
    token, result = get_token()
    casher = {
        "token": token,
        "cardType": "",
        "directPayType": "CCB_B2B",
        "userType": "",
        "timestamp": str(time.time()).split('.')[0],
        "merchantNo": "10030767124",
    }

    return 'https://cash.yeepay.com/cashier/std?' + sign_data(casher)



response = {"response": "YJXEvDCrS2PNikY6xS2aIHwweYXtuWBdEN00_WghGSo5G-fRWvAx6H9KjECeQl1f_AFndNr1-WkHd_qEhuLx8uOxqFi-KAEYoDDzz0hoKylPZyqIwjQTOpAvul1osYnR-ipbK-Cz1iaN0XenkSDqYGH8g3l0_qnqonGERia5YwWjvEdQ2vi9WVZPk73hXIdMEcY0nR-UhiN7MzXRkINChnJYgZ6NEc_t5ahUT838gn0bFK69D3FFcl0FN-cppMV0anRaE-lkfOhVq-qA49fQLvq0lpFgA2IcrMrjVpNHDELTa0eHdQaIdgUGu0gl_xEHKok3F82Wd728Ra-cYpvalA$kimabwGDVfSpivkMODngonJgJkpsrz6A5BhjN4jqEjSmNX97Jihtjnn4KW-TH1PYLkv7KesqAgixHpUx_56C7f-ieWdJotgC4BfdRrqKe9czFLGMd8v9gupSO7RsIwq-X5_sJSrhNJC2j_g_ppBLaay8sKflbxFKY2z50ZUedwtpxQtO7pdvUP6RKymQrjFLV7O9soRMY3E-VYgsNc5RJSqYTJrtMpXnuAX4mjmZI1qsOfcQDPoF-5Zs6sfiGrMwI6FR3uCIJkt5xxm-FX8PoNmEEMUfXbBJyzoeq5COX7KDs6P0uOK2stDMLaGBlUt0yMMsiOUhjvXadIUoqtB5WNiDX-p5sU4w7-ycwrgZQcDhmS2wugkFs_ra0SICEdencIJXsGPyot_hBz7WRGw2jL6QvCgOxo0PRiCF9qQy8sc1D-ESAYHEbG8hK5TmKofFPhKn5wU-4gpNlfUxsHqskNyzVFGD_5FSVkzT8NQ1K1ty3mgA0iKlSAG10ZYLl44I_iW2TWElCkhDrqwZ24prXPzzZnaHZZojMMV70TqzzO1uCDPMryBKOEesOJBGioY1w0tbmXKUfoy2GoyDKw7SYATDxJ6SrvrXjyCz1JeHkLBaE6iiOuVIzFJg3u-UEC5xYDMGahh3E-ighg5pCLdA9vTuPSHdcPtTC-OS5y5e7M1PXkFsd3oB71boinX7VOXcJrj1CIslQBhAaOZeBIyEapVWj7h0a1Xqo17VeILgh-Yc3HBoJBv2AyadU7mXKnclhIKFP_ijgBCuQWTlDM9bTI3IRn_Io11jjChgITZ7xX69tQfr_e0fSZY-NjOo2LzKPYGbydziKdd8DHNfTpwD45a5Hb0-3TV7cfJDaUnEs5IkDWuBYEWfeq9YGtz_SfckeneIQ2hIe_6DHtjNG2-dvKRByIGZEEveW9f_a24KCER3doJD_nbprAMIftnhiFSECROUYLuNNxdjrmoA8z5W12zRKofuKUC3VrWIN0FDX5kiVUYETODfdhDQ6CwxQORqpKCb0gkrcm_R5UHg_1BsUMeqRSp69Ga1y2Qg7_CrkXirWeS2OuGrwvSTF1X5J5u70h7ZZ5WtSfeW2eVloxiybilAKyofzGd2heyHuv2NWvyLvve6VIbnb_QZzI3awSPrhPnj2HmhqFdv-Cch3xrPnjyAbx55KvvgXKzgn_2dV40mIgi6ob98AA404bV4achPw1-pKs4m1976Qaqr5GP0UowTUl8VkbViumbGZuTwUIPkY9-nDx7UmYTVEep0-6vI$AES$SHA256", "customerIdentification": "OPR:10000466938"}

# print(gen_url())
content = "MlT5L9V0wXJvxYbr0vt884KldrhII43Cz3oakzUs0qINouq7FtE-0Cini6wZEn8KfnhmJy5tjOVDBV05O7elJn9K4eKWiu7KvMiC4c-hUsp2PwVabDMdGIzuKbdOll4g0iJtP0i3v5lJYCjPuDop3fJBhBMsg6a-s_f-qsgUz5dcIFZ6Er1YnawVAqRYMCSLxVu-HUjFDVsoleS9JbUO7QTi4pqm8q_31Xa_mkkDLSbOFKXCAesBdnUXMI-cWoHRJUa7TI99mPcKSVnIS6YzCgmzL82rIfaw4mAUYZc7pcpRih6lGK_Q4KkYa-RamjmUboKXMAvXoov4ZUnvP1S7hw$iDahshPMR787tiTxbc3NKvYzkUmxRIFIbQPm4XQYYbQZB2sv2Ywl4hxJaVaaQg8ah1fOAfqkNISMBhrE86P4dq3WO2U6QjfHj74YIPV8lWFWH83XUgD6radUwBgFEn2ialmhhOFeN1LF0yUghz9CkXIjuknJ8g29i8aEWcXGq9OU7-r5zLkF5zqNKgExvDvdX-7gXBgE0eMfYHPDGZPGyB5aNzIut4WZVRfAo-YrtLHrHeiJzjyZADQiiIYF-OBR4oFt_GwwRUwQQo04xUnuE1RDUTHOXLVmMti8hu65nV-H34MdNNR2laXfQiGgXtNbl0Yzgw8U5GdDmbrpedo3iSUsOuOe3umuciIlsNeL-SWOy0VRdFEyjl98DYMa_-x3UlToKKEOQ64WgoxOjMzyZannZ1pQx2gIwbrGiO08SxpXo0bNL4olbJh3qyJaKbOskgfIg5szU-CXCLq58Nci7za3SVTAxtISGfRQGj1V5c86PspCct2G2eL4JXGcHIr8DjbHgNHfz27v7LFTlWB9wOlnnTDk_LBR6M3-Gn94zXTBYf4S50CUdj9mRNShF6IwKocLkXFR1EPI5ludsfNBP_bC1gOxfKyGgNG4P1xYNEUmlIUEMSeyuY_BzkYV1GAatkAGIXaNDSMuFhnm9mWydxAMWZY40BVqJhPnjh7kWmvGXWt7yZ2kVy72C7XotXOmPX22kuUXntvBLPywttkXs0Ykv_n-2dLQTgZWNYt9L3PMqMhiRqhKswgPFfDeUM7HLCHS9RRi-PwvknUmA5uWMKZRxoykuLXeo35Md0dELbBVVVI2Vj9_ImgrVVi1vv8pq1qwPFx_uKQpWi4t3Kvp4VlOgmSVvdACpMGyukZ_ZSQ7Ip_eKuRlt4Oqv9h_exSLu5o7rOubHR_MVpgNlLKtZeVYxW8oLo2FvPuzpZl3B262FSwrgA03xUz_Sjren_m5KyQ3zhNfQqROTK0H3umMSMe2eZsrnhIFIDt6nSuqjSdlqUSR5hOTlduO1cMllstoXqeS7F5-E0JmGzVWm9ACrFHNtX4JbhdvW1EAdRPk5iuR-PxropC-2gt8vVxdacOIWv3TfnWPaNFwNpd1To-I51SXRWDrWrUQ6R_5fUZHECChOnTOqAWubi4t2ImaT6YUNgFJuuk7SzHr7zdkCae36XNnhVamZhYnEq7QzvBOdm7ZaWKbKXh87fvKpVDbnKMMYkCDcl0dnsP66EL8wwQ0iCjyse7Se2-IeceNivclHwZLJACK_qcP8A0rWJwdgogluq-YkUnWUtDHcb3yevPPNQ$AES$SHA256"
print(gen_url())
# source_data, sign_to_base64 = yop_security_utils.decrypt(content)
#
# print(source_data, sign_to_base64)