# coding=utf-8
import datetime
from django.core.management import BaseCommand

from api.models import SimpleActionLog


class Command(BaseCommand):
    """
    更新日志数据 python manage.py async_log_data
    """

    def handle(self, *args, **options):
        pass_file = open('pass_due.txt', 'r')
        pass_result_success = open('pass_result_success.txt', 'a')
        pass_result_erro = open('pass_result_erro.txt', 'a')
        while True:
            lines = pass_file.readlines(100000)
            if lines:
                for line in lines:
                    pass_data = line.strip('\n').split(',')
                    pass_time = datetime.datetime.strptime(pass_data[0], '%Y-%m-%d %H:%M:%S')
                    service_id = int(pass_data[1])
                    user = int(pass_data[2])
                    log_data = SimpleActionLog.objects.filter(
                        action_time__gte=pass_time + datetime.timedelta(seconds=-60),
                        action_time__lte=pass_time + datetime.timedelta(seconds=60),
                        object_type=u'serviceregister',
                        action_new=2,
                        action='',
                        message=str(service_id),
                        user_id=user
                    )
                    if len(log_data) > 1:
                        result_line = line.strip('\n') + u',result:'
                        for item in log_data:
                            result_line += str(item.id)
                            result_line += u','
                        result_line += u'\n'
                        pass_result_erro.writelines(result_line)
                    elif len(log_data) == 1:
                        log_data[0].action_new = 11
                        log_data[0].save()
                        result_line = line.strip('\n') + u',result:'
                        result_line += str(log_data[0].id)
                        result_line += u'\n'
                        pass_result_success.writelines(result_line)
            else:
                break
        pass_file.close()
        pass_result_erro.close()
        pass_result_success.close()

        audit_reject_file = open('audit_reject_due.txt', 'r')
        audit_reject_result_success = open('audit_reject_result_success.txt', 'a')
        audit_reject_result_erro = open('audit_reject_result_erro.txt', 'a')
        while True:
            lines = audit_reject_file.readlines(100000)
            if lines:
                for line in lines:
                    audit_reject_data = line.strip('\n').split(',')
                    audit_reject_time = datetime.datetime.strptime(audit_reject_data[0], '%Y-%m-%d %H:%M:%S')
                    service_id = int(audit_reject_data[1])
                    user = int(audit_reject_data[2])
                    log_data = SimpleActionLog.objects.filter(
                        action_time__gte=audit_reject_time + datetime.timedelta(seconds=-1),
                        action_time__lte=audit_reject_time + datetime.timedelta(seconds=1),
                        object_type='serviceregister',
                        action_new=2,
                        action='',
                        message=str(service_id),
                        user_id=user
                    )
                    if len(log_data) > 1:
                        result_line = line.strip('\n') + u',result:'
                        for item in log_data:
                            result_line += str(item.id)
                            result_line += u','
                        result_line += u'\n'
                        audit_reject_result_erro.writelines(result_line)
                    elif len(log_data) == 1:
                        log_data[0].action_new = 12
                        log_data[0].save()
                        result_line = line.strip('\n') + u',result:'
                        result_line += str(log_data[0].id)
                        result_line += u'\n'
                        audit_reject_result_success.writelines(result_line)

            else:
                break

        audit_reject_file.close()
        audit_reject_result_erro.close()
        audit_reject_result_success.close()
