#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   16/07/01 14:18:25
#   Desc    :   处理老的礼包迁移
#
from __future__ import absolute_import, division, with_statement

from datetime import datetime

from django.core.management import BaseCommand
from django.db.models import Max, Min

from api.models import CouponGift, ChannelGift


class Command(BaseCommand):

    def handle(self, *args, **options):
        for gift in CouponGift.objects.all():
            total = gift.total or 100000
            ChannelGift.objects.create(
                gift=gift, business_channel_id=gift.channel, total=total,
                activated_time=datetime.now())
            gift.start_time = gift.coupon.aggregate(start=Min('start_time'))['start']
            gift.end_time = gift.coupon.aggregate(end=Max('end_time'))['end']
            gift.save()
