#!/usr/bin/env python
# -*- coding: utf-8 -*-

from django.core.management import BaseCommand

from api.models import BeautyPhoto


class Command(BaseCommand):
    def handle(self, *args, **options):
        print("start")
        beautiful_list = BeautyPhoto.objects.filter(
            is_online=True).values_list("url", "gender")
        write_list = []
        for url, gender in beautiful_list:
            _data = "{url} {gender}\n"
            write_list.append(_data.format(url=url, gender=gender))

        with open("/tmp/export_beautiful_photo_urls.txt", "w+") as f:
            f.writelines(write_list)

        print("end")
