# coding=utf-8
import tablib
from django.core.management import BaseCommand

from api.models import SpecialItem


class Command(BaseCommand):
    """
    python manage.py export_special_services special_id
    """

    def add_arguments(self, parser):
        parser.add_argument('special_id', nargs='+', type=int)

    def handle(self, *args, **options):
        dt1 = tablib.Dataset()
        dt1.headers = [u'专题ID', u'美购ID', u'美购名称', u'多属性ID', u'多属性名称', u'更美价', u'预付款', u'抽成', u'返现', u'美购是否支持随时退款']
        for line in options['special_id']:
            try:
                special_id = int(line)
                special_services = SpecialItem.objects.filter(special_id=special_id)
                for special_service in special_services:
                    for item in special_service.service.items.filter(is_delete=False):
                        row = []
                        row.append(special_service.special_id)
                        row.append(special_service.service.id)
                        row.append(special_service.service.name)
                        row.append(item.id)
                        row.append(''.join(item.items_name))
                        row.append(item.gengmei_price)
                        row.append(item.pre_payment_price)
                        row.append(item.discount)
                        row.append(item.cash_back_fee)
                        row.append(service.refund_anytime)
                        print item.id
                        dt1.append(row)
            except Exception as e:
                print e.message
                continue
        open(u'special_services.xlsx', 'wb').write(dt1.xlsx)
        print (u"导出成功!!")
