# coding=utf-8

import redis
from django.core.management import BaseCommand
from django.conf import settings

from rpc.cache import diary_pv_cache


diary_pool = redis.ConnectionPool(**settings.REDIS['diary'])
prefix = "api_diary_pageview"
client = redis.Redis(connection_pool=diary_pool)
get_k = lambda x: x.split('%s:' % prefix)[1]


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        for k in client.keys('%s:*' % prefix):
            diary_id = get_k(k)
            print('handling diary: %s, with key: %s' % (diary_id, k))
            diary_pv_cache.incrby(diary_id, client.get(k))
