# coding=utf-8
from django.core.management import BaseCommand
from openpyxl import load_workbook

from api.models import SpecialSeckillService


class Command(BaseCommand):
    """
    批量修改秒杀美购的更美价和秒杀价 python manage.py replace_specila_service_data
    """

    def handle(self, *args, **options):
        wb = load_workbook(filename=u'replace_data.xlsx')
        sheetnames = wb.get_sheet_names()
        ws = wb.get_sheet_by_name(sheetnames[0])
        for rx in range(2, ws.get_highest_row()):
            try:
                service_id = ws.cell(row=rx, column=1).value
                service_apecial = SpecialSeckillService.objects.filter(service_id=service_id)
                for item in service_apecial:
                    item.seckill_price += 11
                    item.commission += 11
                    item.pre_payment_price += 11
                    item.save()
                    message = str(item.id) + \
                              u',' + \
                              str(item.seckill_price) + \
                              u',' + \
                              str(item.commission) + \
                              u',' + \
                              str(item.pre_payment_price)
                    print message
            except Exception:
                continue
