# coding=utf-8
from django.core.management import BaseCommand
from django.db import transaction

from api.models import SpecialItem, ServiceItem


class Command(BaseCommand):
    """
    处理美购专场的数据(由service转化为serviceitem)
    python manage.py set_serviceitem_on_specialitem
    create by pengli 2016-11-28
    """

    def handle(self, *args, **options):
        specialitems = SpecialItem.objects.filter(service__isnull=False)
        list_specialitems = []
        for spe_item in specialitems:
            list_specialitems.append({
                "id": spe_item.id,
                # "special_id": spe_item.special.id,
                # "service_id": spe_item.service.id,
                # "subtitle": spe_item.subtitle,
                # "image_url": spe_item.image_url,
                # "rank": spe_item.rank,
                # "is_recommend": spe_item.is_recommend,
                # "name": spe_item.name,
            })
        print ("数据加载完成!")
        result_log_modify = open(u'/data/shuangshier/modify.txt', 'a')
        result_log_add = open(u'/data/shuangshier/add.txt', 'a')
        result_log_erro = open(u'/data/shuangshier/erro.txt', 'a')
        for sp_item in list_specialitems:
            try:
                item = SpecialItem.objects.get(id=sp_item['id'])
                with transaction.atomic():
                    serviceitems = ServiceItem.objects.filter(service_id=item.service.id)
                    if serviceitems.count() < 1:
                        continue
                    else:
                        print item.id
                        item.serviceitem = serviceitems[0]
                        add_message = str(item.id) + '\n'
                        result_log_modify.writelines(add_message)
                        item.save()
                    if serviceitems.count() > 1:
                        for serviceitem in serviceitems:
                            if item.serviceitem.id == serviceitem.id:
                                continue
                            special_item = SpecialItem.objects.create(
                                name=item.name,
                                subtitle=item.subtitle,
                                image_url=item.image_url,
                                service_id=item.service.id,
                                special=item.special,
                                rank=item.rank,
                                is_recommend=item.is_recommend,
                                serviceitem_id=serviceitem.id
                            )
                            modify_message = str(special_item.id) + '\n'
                            result_log_add.writelines(modify_message)
            except Exception as e:
                erro_message = 'erro' + str(e.message) + ',' + str(sp_item['id']) + '\n'
                print erro_message
                result_log_erro.writelines(erro_message)
                continue
        print u'Done!'
        result_log_modify.close()
        result_log_add.close()
        result_log_erro.close()
