# coding=utf-8
import traceback

from django.core.management import BaseCommand

from api.models import TopicImage, IMAGE_TYPE


class Command(BaseCommand):

    def handle(self, *args, **options):
        images = TopicImage.objects.all()
        for image in images:
            try:
                image.image_type = IMAGE_TYPE.POST_OPERATION_IMAGE
                if image.topic.diary is not None:
                    if image.image_url == image.topic.diary.pre_operation_image:
                        image.image_type = IMAGE_TYPE.PRE_OPERATION_IMAGE
                        print "pre:", image.image_url
                image.save()
                print "save", image.image_url, IMAGE_TYPE.POST_OPERATION_IMAGE, image.image_type
            except:
                traceback.print_exc()