#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2019/7/12

from django.core.management import BaseCommand

from api.models.order import Order
from api.models.servicecomment import ServiceComment


class Command(BaseCommand):
    def handle(self, *args, **options):
        print('')
        order_ids = set(ServiceComment.objects.values_list("order_id", flat=True))
        print("----------total orders: %d----------------" % len(order_ids))
        for order_id in order_ids:
            if not order_id:
                continue

            print('-------------order_id: %s---------' % order_id)
            order = Order.objects.get(id=order_id)
            order.order_has_service_comment = True
            order.save()
